/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.illusivesoulworks.constructsarmory.ConstructsArmoryMod;
import com.james.tinkerscalibration.ConstructsArmoryIntegration;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.TotalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.modifiers.upgrades.general.ReinforcedModifier;

public class ArmorIgneousModifier
extends TotalArmorLevelModifier {
    private static final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "igneous_mod");
    private static final Component UNBREAKING = TConstruct.makeTranslation((String)"modifier", (String)"igneous.unbreaking");
    private static final TinkerDataCapability.TinkerDataKey<Integer> IGNEOUS = ConstructsArmoryMod.createKey((String)"igneous_armor");

    public ArmorIgneousModifier() {
        super(IGNEOUS);
        MinecraftForge.EVENT_BUS.addListener(ArmorIgneousModifier::onUpdateApply);
    }

    private static void onUpdateApply(LivingEvent.LivingUpdateEvent evt) {
        EquipmentContext context;
        LivingEntity living = evt.getEntityLiving();
        if (!living.m_5833_() && (context = new EquipmentContext(living)).hasModifiableArmor() && !living.f_19853_.f_46443_ && living.m_6084_()) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
                IToolStackView patt5496$temp;
                IToolStackView patt4923$temp;
                IToolStackView patt4349$temp;
                ToolStack tool;
                ModDataNBT persistentData = null;
                IToolStackView patt3776$temp = context.getToolInSlot(EquipmentSlot.LEGS);
                if (patt3776$temp instanceof ToolStack && (persistentData = (tool = (ToolStack)patt3776$temp).getPersistentData()).getFloat(KEY) <= 5.0f && living.m_6060_() && RANDOM.nextFloat() <= (float)tool.getModifierLevel(ConstructsArmoryIntegration.igneous.get()) * 0.6f && living.f_19797_ % 100 == 0) {
                    persistentData.putFloat(KEY, persistentData.getFloat(KEY) + 0.1f);
                }
                if ((patt4349$temp = context.getToolInSlot(EquipmentSlot.HEAD)) instanceof ToolStack && (persistentData = (tool = (ToolStack)patt4349$temp).getPersistentData()).getFloat(KEY) <= 5.0f && living.m_6060_() && RANDOM.nextFloat() <= (float)tool.getModifierLevel(ConstructsArmoryIntegration.igneous.get()) * 0.6f && living.f_19797_ % 100 == 0) {
                    persistentData.putFloat(KEY, persistentData.getFloat(KEY) + 0.1f);
                }
                if ((patt4923$temp = context.getToolInSlot(EquipmentSlot.CHEST)) instanceof ToolStack && (persistentData = (tool = (ToolStack)patt4923$temp).getPersistentData()).getFloat(KEY) <= 5.0f && living.m_6060_() && RANDOM.nextFloat() <= (float)tool.getModifierLevel(ConstructsArmoryIntegration.igneous.get()) * 0.6f && living.f_19797_ % 100 == 0) {
                    persistentData.putFloat(KEY, persistentData.getFloat(KEY) + 0.1f);
                }
                if ((patt5496$temp = context.getToolInSlot(EquipmentSlot.FEET)) instanceof ToolStack && (persistentData = (tool = (ToolStack)patt5496$temp).getPersistentData()).getFloat(KEY) <= 5.0f && living.m_6060_() && RANDOM.nextFloat() <= (float)tool.getModifierLevel(ConstructsArmoryIntegration.igneous.get()) * 0.6f && living.f_19797_ % 100 == 0) {
                    persistentData.putFloat(KEY, persistentData.getFloat(KEY) + 0.1f);
                }
            });
        }
    }

    public int onDamageTool(IToolStackView tool, int level, int amount, @Nullable LivingEntity holder) {
        ModDataNBT persistantData = tool.getPersistentData();
        if (persistantData.contains(KEY, 5)) {
            float value = persistantData.getFloat(KEY);
            if (value >= (float)level / 5.0f) {
                return ReinforcedModifier.damageReinforced((int)amount, (float)((float)(0.1 * (double)level)));
            }
            return ReinforcedModifier.damageReinforced((int)amount, (float)(value / 10.0f));
        }
        return amount;
    }

    public boolean isArmor(EquipmentSlot slot) {
        return slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
    }

    public void addAttributes(IToolStackView tool, int level, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        float current;
        if (this.isArmor(slot) && (current = tool.getPersistentData().getFloat(KEY)) != 0.0f) {
            consumer.accept(Attributes.f_22284_, new AttributeModifier(UUID.fromString("115d9b72-da0c-4395-bfab-2f2287d6d1eb"), Attributes.f_22284_.m_22087_(), (double)current * 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
            consumer.accept(Attributes.f_22285_, new AttributeModifier(UUID.fromString("93bdef84-fac5-4445-90b6-fed434adcdfe"), Attributes.f_22285_.m_22087_(), (double)current * 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
            consumer.accept(Attributes.f_22278_, new AttributeModifier(UUID.fromString("fdcd922f-7891-4d6f-bf61-226e85c1b174"), Attributes.f_22278_.m_22087_(), (double)current * 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }
}

